implementation module menuhandle


import	StdInt, StdBool, StdChar, StdString, StdArray, StdList, StdFunc, StdTuple, StdMaybe
import	id, menudefaccess, receiverhandle, receivertable, commondef
import	osmenu

::	MenuElementState		ls ps							// The internal implementation of a menu element
	:==	MenuElementHandle	ls ps							// is a MenuElementHandle

::	MenuHandles ps
	=	{	mMenus			:: [MenuStateHandle ps]			// The menus and their elements of a process
		,	mKeys			:: [Char]						// All shortcut keys of the menus
		,	mOSMenuBar		:: OSMenuBar					// The handle to the toolbox menu bar
		,	mMenuIds		:: [Int]						// Fresh menuIds
		,	mEnabled		:: Bool							// Flag: the whole menusystem is enabled
		,	mNrMenuBound	:: Bound						// The maximum number of menus that are allowed to be opened
		,	mDoASync		:: Bool							// Flag: there are MenuReceivers with non-empty queues
		}
::	MenuStateHandle ps
	=	E..ls: MenuLSHandle	(MenuLSHandle ls ps)			// A menu with local state
::	MenuLSHandle ls ps
	=	{	mlsState		:: ls							// The local state of this menu
		,	mlsHandle		:: MenuHandle ls ps				// The menu implementation
		}
::	MenuHandle ls ps
	=	{	mHandle			:: OSMenu						// The handle to the menu as created on the Mac
		,	mMenuId			:: Id							// The menu id
		,	mOSMenuNr		:: OSMenuNr						// The OSMenuNr
		,	mTitle			:: String						// The title of the menu
		,	mSelect			:: Bool							// The MenuSelect==Able (by default True)
// PA---,	mLS				:: Bool							// The menu has local state (True iff works on local state)
		,	mItems			:: [MenuElementHandle ls ps]	// The menu elements of this menu
		}
::	MenuElementHandle ls ps
	=	MenuItemHandle		(MenuItemHandle		 ls ps)
	|	MenuReceiverHandle	(MenuReceiverHandle	 ls ps)
	|	SubMenuHandle		(SubMenuHandle		 ls ps)
	|	RadioMenuHandle		(RadioMenuHandle	 ls ps)
	|	MenuSeparatorHandle	(MenuSeparatorHandle ls ps)
	|	MenuListLSHandle	[MenuElementHandle	 ls ps]
	|	MenuExtendLSHandle	(MenuExtendLSHandle	 ls ps)
	|	MenuChangeLSHandle	(MenuChangeLSHandle	 ls ps)
::	MenuItemHandle ls ps
	=	{	mItemId			:: Maybe Id
		,	mItemKey		:: Maybe Char
		,	mItemTitle		:: Title
		,	mItemSelect		:: Bool
		,	mItemMark		:: Bool
// PA---,	mItemLS			:: Bool
		,	mItemAtts		:: [MenuAttribute *(ls,ps)]
		,	mOSMenuItem		:: OSMenuItem
		}
::	MenuReceiverHandle ls ps
// PA---=	{	mReceiverLS		:: Bool
	=	{	mReceiverHandle	:: ReceiverHandle ls ps
		,	mReceiverAtts	:: [MenuAttribute *(ls,ps)]
		}
::	SubMenuHandle ls ps
	=	{	mSubHandle		:: OSMenu
		,	mSubMenuId		:: Maybe Id
		,	mSubOSMenuNr	:: OSSubMenuNr
		,	mSubItems		:: [MenuElementHandle ls ps]
		,	mSubTitle		:: Title
		,	mSubSelect		:: Bool
// PA---,	mSubLS			:: Bool
		,	mSubAtts		:: [MenuAttribute *(ls,ps)]
		}
::	RadioMenuHandle ls ps
	=	{	mRadioId		:: Maybe Id
		,	mRadioIndex		:: Int
		,	mRadioItems		:: [MenuElementHandle ls ps]
		,	mRadioSelect	:: Bool
// PA---,	mRadioLS		:: Bool
		,	mRadioAtts		:: [MenuAttribute *(ls,ps)]
		}
::	MenuSeparatorHandle	ls ps
	=	{	mSepId			:: Maybe Id
// PA---,	mSepLS			:: Bool
		,	mOSMenuSeparator:: OSMenuSeparator
		}
::	MenuExtendLSHandle	ls ps
	=	E..ls1:
		{	mExtendLS		:: ls1
		,	mExtendItems	:: [MenuElementHandle *(ls1,ls) ps]
		}
::	MenuChangeLSHandle	ls ps
	=	E..ls1:
		{	mChangeLS		:: ls1
		,	mChangeItems	:: [MenuElementHandle ls1 ps]
		}


//	Conversion functions from MenuElementState to MenuElementHandle, and vice versa:
MenuElementHandleToMenuElementState	:: !(MenuElementHandle .ls .ps) -> MenuElementState  .ls .ps
MenuElementHandleToMenuElementState mH = mH

MenuElementStateToMenuElementHandle	:: !(MenuElementState  .ls .ps) -> MenuElementHandle .ls .ps
MenuElementStateToMenuElementHandle mH = mH

/*	menuIdsAreConsistent checks whether the MenuElementHandles contain R(2)Ids that have already been
	associated with open receivers and if there are no duplicate Ids. 
	The ReceiverTable is not changed if there are duplicate R(2)Ids; otherwise all R(2)Ids have been bound.
*/
menuIdsAreConsistent :: !SystemId !Id ![MenuElementHandle .ls .ps] !ReceiverTable
							-> (!Bool,![MenuElementHandle .ls .ps],!ReceiverTable)
menuIdsAreConsistent ioId menuId itemHs rt
	| not (noDuplicates ids)
	= (False, itemHs1,rt)
	= (okRIds,itemHs2,if okRIds rt1 rt)
where
	(ids,   itemHs1)	= getMenuElementMenuIds itemHs
	(okRIds,itemHs2,rt1)= bindReceiverMenuIds ioId menuId itemHs1 rt
	
	getMenuElementMenuIds :: ![MenuElementHandle .ls .ps] -> (![Id],![MenuElementHandle .ls .ps])
	getMenuElementMenuIds [itemH:itemHs]
		# (ids1,itemH)	= getMenuElementMenuId  itemH
		# (ids2,itemHs)	= getMenuElementMenuIds itemHs
		= (ids1++ids2,[itemH:itemHs])
	where
		getMenuElementMenuId :: !(MenuElementHandle .ls .ps) -> (![Id],!MenuElementHandle .ls .ps)
		getMenuElementMenuId itemH=:(MenuItemHandle {mItemId})
			| isNothing mItemId
				= ([],itemH)
				= ([fromJust mItemId],itemH)
		getMenuElementMenuId itemH=:(MenuReceiverHandle _)
			= ([],itemH)
		getMenuElementMenuId (SubMenuHandle itemH=:{mSubMenuId,mSubItems=itemHs})
			# (ids,itemHs)	= getMenuElementMenuIds itemHs
			  subH			= SubMenuHandle {itemH & mSubItems=itemHs}
			| isNothing mSubMenuId
				= (ids,subH)
				= ([fromJust mSubMenuId:ids],subH)
		getMenuElementMenuId (RadioMenuHandle itemH=:{mRadioId,mRadioItems=itemHs})
			# (ids,itemHs)	= getMenuElementMenuIds itemHs
			  radioH		= RadioMenuHandle {itemH & mRadioItems=itemHs}
			| isNothing mRadioId
				= (ids,radioH)
				= ([fromJust mRadioId:ids],radioH)
		getMenuElementMenuId itemH=:(MenuSeparatorHandle {mSepId})
			| isNothing mSepId
				= ([],itemH)
				= ([fromJust mSepId],itemH)
		getMenuElementMenuId (MenuListLSHandle itemHs)
			# (ids,itemHs)	= getMenuElementMenuIds itemHs
			= (ids,MenuListLSHandle itemHs)
		getMenuElementMenuId (MenuExtendLSHandle mExH=:{mExtendItems=itemHs})
			# (ids,itemHs)	= getMenuElementMenuIds itemHs
			= (ids,MenuExtendLSHandle {mExH & mExtendItems=itemHs})
		getMenuElementMenuId (MenuChangeLSHandle mChH=:{mChangeItems=itemHs})
			# (ids,itemHs)	= getMenuElementMenuIds itemHs
			= (ids,MenuChangeLSHandle {mChH & mChangeItems=itemHs})
	getMenuElementMenuIds _
		= ([],[])
	
	bindReceiverMenuIds :: !SystemId !Id ![MenuElementState .ls .ps] !ReceiverTable
							   -> (!Bool,![MenuElementState .ls .ps],!ReceiverTable)
	bindReceiverMenuIds ioId menuId [itemH:itemHs] rt
		# (ok,itemH,rt)	= noDuplicateMenuReceiverIds` ioId menuId itemH rt
		| not ok
		= (ok,[itemH:itemHs],rt)
		# (ok,itemHs,rt)= bindReceiverMenuIds ioId menuId itemHs rt
		= (ok,[itemH:itemHs],rt)
	where
		noDuplicateMenuReceiverIds` :: !SystemId !Id !(MenuElementHandle .ls .ps) !ReceiverTable
											-> (!Bool,!MenuElementHandle .ls .ps, !ReceiverTable)
		noDuplicateMenuReceiverIds` ioId menuId itemH=:(MenuReceiverHandle {mReceiverHandle={rId,rSelect}}) rt
			# opt_parent= getReceiverTableEntry rId rt
			| isJust opt_parent
			= (False,itemH,rt)
			# rte		= {	rteLoc			= {	rlIOId		= ioId
											  ,	rlDevice	= MenuDevice
											  ,	rlParentId	= menuId
											  ,	rlReceiverId= rId
											  }
						  ,	rteSelectState	= rSelect
						  ,	rteASMCount		= 0
						  }
			# (_, rt)	= addReceiverToReceiverTable rte rt
			= (True,itemH,rt)
		noDuplicateMenuReceiverIds` ioId menuId (SubMenuHandle itemH=:{mSubItems=itemHs}) rt
			# (ok,itemHs,rt)	= bindReceiverMenuIds ioId menuId itemHs rt
			= (ok,SubMenuHandle {itemH & mSubItems=itemHs},rt)
		noDuplicateMenuReceiverIds` ioId menuId (MenuListLSHandle itemHs) rt
			# (ok,itemHs,rt)	= bindReceiverMenuIds ioId menuId itemHs rt
			= (ok,MenuListLSHandle itemHs,rt)
		noDuplicateMenuReceiverIds` ioId menuId (MenuExtendLSHandle	mExH=:{mExtendItems=itemHs}) rt
			# (ok,itemHs,rt)	= bindReceiverMenuIds ioId menuId itemHs rt
			= (ok,MenuExtendLSHandle {mExH & mExtendItems=itemHs},rt)
		noDuplicateMenuReceiverIds` ioId menuId (MenuChangeLSHandle	mChH=:{mChangeItems=itemHs}) rt
			# (ok,itemHs,rt)	= bindReceiverMenuIds ioId menuId itemHs rt
			= (ok,MenuChangeLSHandle {mChH & mChangeItems=itemHs},rt)
		noDuplicateMenuReceiverIds` _ _ itemH rt
			= (True,itemH,rt)
	bindReceiverMenuIds _ _ itemHs rt
		= (True,itemHs,rt)

//	Convert a RadioMenuItem to the MenuItemHandle alternative of MenuElementHandle:
RadioMenuItemToMenuElementHandle :: !(MenuRadioItem *(.ls,.ps)) -> MenuElementHandle .ls .ps
RadioMenuItemToMenuElementHandle (title,optId,optShortKey,f)
	= MenuItemHandle {	mItemId		= optId
					 ,	mItemKey	= optShortKey
					 ,	mItemTitle	= title
					 ,	mItemSelect	= True
					 ,	mItemMark	= False
		// PA---	 ,	mItemLS		= True
					 ,	mItemAtts	= [MenuFunction f]
					 ,	mOSMenuItem	= OSNoMenuItem
					 }
